Rem AlignToPage.vbs
Rem An InDesign VBScript
Rem
Rem Aligns the items in the selection to the specified location on the page.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem Or visit the InDesign Scripting User to User forum at http://www.adobeforums.com.
Rem
main
Function main()
	ReDim myObjectList(0)
	Set myInDesign = CreateObject("InDesign.Application.2021")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count <> 0 Then
	    If myInDesign.Selection.Count <> 0 Then
	        For myCounter = 1 To myInDesign.Selection.Count
	            Select Case TypeName(myInDesign.Selection.Item(myCounter))
	                Case "Rectangle", "Oval", "Polygon", "GraphicLine", "Button", "Group", "TextFrame"
	                    If Not (IsEmpty(myObjectList(0))) Then
	                        ReDim Preserve myObjectList(UBound(myObjectList) + 1)
	                    End If
	                    Set myObjectList(UBound(myObjectList)) = myInDesign.Selection.Item(myCounter)
	            End Select
	        Next
	        If Not (IsEmpty(myObjectList(0))) Then
	            myDisplayDialog myInDesign, myObjectList
	        End If
	    Else
	        MsgBox ("Nothing is selected. Please select an object and try again.")
	    End If
	Else
	    MsgBox ("Please open a document, select an object, and try again.")
	End If
End Function 
Function myDisplayDialog(myInDesign, myObjectList)
    Set myDialog = myInDesign.Dialogs.Add
    myDialog.name = "AlignToPage"
    With myDialog.DialogColumns.Add
        With .DialogRows.Add
            With .DialogColumns.Add
                With .BorderPanels.Add
                    With .StaticTexts.Add
                        .staticLabel = "Vertical"
                    End With
                    Set myVerticalAlignmentButtons = .RadiobuttonGroups.Add
                    With myVerticalAlignmentButtons
                        With .RadiobuttonControls.Add
                            .staticLabel = "Top"
                            .CheckedState = False
                        End With
                        With .RadiobuttonControls.Add
                            .staticLabel = "Center"
                            .CheckedState = True
                        End With
                        With .RadiobuttonControls.Add
                            .staticLabel = "Bottom"
                            .CheckedState = False
                        End With
                        With .RadiobuttonControls.Add
                            .staticLabel = "None"
                            .CheckedState = False
                        End With
                    End With
                End With
            End With
            With .DialogColumns.Add
                With .BorderPanels.Add
                    With .StaticTexts.Add
                        .staticLabel = "Horizontal"
                    End With
                    Set myHorizontalAlignmentButtons = .RadiobuttonGroups.Add
                    With myHorizontalAlignmentButtons
                        With .RadiobuttonControls.Add
                            .staticLabel = "Left"
                            .CheckedState = False
                        End With
                        With .RadiobuttonControls.Add
                            .staticLabel = "Center"
                            .CheckedState = True
                        End With
                        With .RadiobuttonControls.Add
                            .staticLabel = "Right"
                            .CheckedState = False
                        End With
                        With .RadiobuttonControls.Add
                            .staticLabel = "None"
                            .CheckedState = False
                        End With
                    End With
                End With
            End With
        End With
        With .DialogRows.Add
            Set myConsiderMarginsCheckbox = .CheckboxControls.Add
            With myConsiderMarginsCheckbox
                .staticLabel = "Consider Page Margins"
                .CheckedState = False
            End With
        End With
    End With
    myResult = myDialog.Show
    If myResult = True Then
        myVerticalAlignment = myVerticalAlignmentButtons.SelectedButton
        myHorizontalAlignment = myHorizontalAlignmentButtons.SelectedButton
        myConsiderMargins = myConsiderMarginsCheckbox.CheckedState
        myDialog.Destroy
        myAlignObjects myInDesign, myObjectList, myVerticalAlignment, myHorizontalAlignment, myConsiderMargins
    Else
        myDialog.Destroy
    End If
End Function
Function myAlignObjects(myInDesign, myObjectList, myVerticalAlignment, myHorizontalAlignment, myConsiderMargins)
    myPageHeight = myInDesign.ActiveDocument.DocumentPreferences.PageHeight
    myPageWidth = myInDesign.ActiveDocument.DocumentPreferences.PageWidth
    myOldRulerOrigin = myInDesign.ActiveDocument.ViewPreferences.RulerOrigin
    myInDesign.ActiveDocument.ViewPreferences.RulerOrigin = idRulerOrigin.idPageOrigin
    myInDesign.ActiveDocument.ZeroPoint = Array(0, 0)
    Set myPage = myInDesign.ActiveWindow.ActivePage
    Set myMarginPreferences = myPage.MarginPreferences
    If myConsiderMargins = True Then
	    If myPage.Side = idPageSideOptions.idLeftHand Then
		    myOutsideMargin = myMarginPreferences.Left
		    myInsideMargin = myMarginPreferences.Right
		    myXCenter = myOutsideMargin + ((myPageWidth - (myOutsideMargin+myInsideMargin))/2)
	    Else
		    myInsideMargin = myMarginPreferences.Left
		    myOutsideMargin = myMarginPreferences.Right
		    myXCenter = myInsideMargin + ((myPageWidth - (myOutsideMargin+myInsideMargin))/2)
	    End If
	    myTopMargin = myMarginPreferences.Top
	    myBottomMargin = myMarginPreferences.Bottom
	    myYCenter = myTopMargin + ((myPageHeight - (myTopMargin+ myBottomMargin))/2)
        Select Case myHorizontalAlignment
            Case 0:
                myX = myInsideMargin
            Case 1:
                myX = myXCenter
            Case 2:
                myX = myPageWidth - myOutsideMargin
            Case 3:
                myX = "None"
        End Select
        Select Case myVerticalAlignment
            Case 0:
                myY = myTopMargin
            Case 1:
                myY = myYCenter
            Case 2:
                myY = myPageHeight - myBottomMargin
            Case 3:
                myY = "None"
        End Select
    Else
	    myXCenter = myPageWidth / 2
	    myYCenter = myPageHeight / 2
        Select Case myHorizontalAlignment
            Case 0:
                myX = 0
            Case 1:
                myX = myXCenter
            Case 2:
                myX = myPageWidth
            Case 3:
                myX = "None"
        End Select
        Select Case myVerticalAlignment
            Case 0:
                myY = 0
            Case 1:
                myY = myYCenter
            Case 2:
                myY = myPageHeight
            Case 3:
                myY = "None"
        End Select
    End If
    For myCounter = 0 To UBound(myObjectList)
        myAlignObject myObjectList(myCounter), myX, myY, myHorizontalAlignment, myVerticalAlignment
    Next
    myInDesign.ActiveDocument.ViewPreferences.RulerOrigin = myOldRulerOrigin
End Function
Function myAlignObject(myObject, myX1, myY1, myHorizontalAlignment, myVerticalAlignment)
    myBounds = myObject.GeometricBounds
    myWidth = myBounds(3) - myBounds(1)
    myHeight = myBounds(2) - myBounds(0)
    Select Case myHorizontalAlignment
        Case 0:
            myX = myX1
        Case 1:
            myX = myX1 - (myWidth / 2)
        Case 2:
            myX = myX1 - myWidth
        Case 3:
        	myX = myBounds(1)
    End Select
    Select Case myVerticalAlignment
        Case 0:
            myY = myY1
        Case 1:
            myY = myY1 - (myHeight / 2)
        Case 2:
            myY = myY1 - myHeight
        Case 3:
        	myY = myBounds(0)
    End Select
    myObject.Move Array(myX, myY)
End Function

'' SIG '' Begin signature block
'' SIG '' MIIeVAYJKoZIhvcNAQcCoIIeRTCCHkECAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' Ku0zYnMbzxzekUDc7OpAqECVYnTIndJVH62p7in+2i+g
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQB3XcWt35KITbGdVVTAfs
'' SIG '' STANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTE5
'' SIG '' MDEzMTAwMDAwMFoXDTIxMDIwMzEyMDAwMFowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIiKXEE3
'' SIG '' 5FJAWPRPxAu4g1GRRZmzrPW3SZL40s8opqkFWksx2dBE
'' SIG '' yP6+N6visRXUyDy+I979oO9tEtHBeYKx1XHy4NOLPl3u
'' SIG '' Lr8rWv5E3hrNw+QRwJvsMJLzBTS44811Rym8ddkt8lpj
'' SIG '' dG1PmC2aZQ73miR88+46IaZDtuabo3corXvrG0wmLFZb
'' SIG '' SrB80HAigwQiwHgh33cI2pPIYA2VdmEv5V3iI+AuYybL
'' SIG '' BPJ32YPqdvcoR3Ml/oYFcFlUb1sliNdngwqEeUTKBWVu
'' SIG '' OTeuRo2gOioizpUxR3cce25eoH8wONWUozkjPwcUEY8I
'' SIG '' RCePRf21c4kjjLGFSmpwEVQVQJcCAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBSVoz2+cIajBhNjiGb0VJBYxDX9vzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEADtCQA7go0Xu2UKN6dFPe
'' SIG '' YJbS/OXx3n3IP0K9CGPDozeGV62MvbCp+DuptFa44FYR
'' SIG '' ZuljRXMxCjsjJmkJLD9Hhuik+a23iSwfOAnWK6AY/VoD
'' SIG '' ZatWvGG6mZzMRs/s5Whztt8IRxLMrLbA+ulDkDKTlqqf
'' SIG '' BWN8xAM23VX2IMmPYFXMf1TgyT3rCr2oontG6eWT0VYa
'' SIG '' j8DrYJuWtoNQaHIxSg3lGWyvqi1RwJc7GjVwJObnRCTH
'' SIG '' Faqmfxwry/5jEDjPNNUyDiMWIr2xxCbe5pu759mb9Hjl
'' SIG '' rSakmU9AhIxEURqKA3wmnF9Sw+OnazRGp4bvfkCeWDtK
'' SIG '' LdN4JKj5eh21hDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCERgwghEUAgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAd13Frd+SiE2xnVVUwH7Ekw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEICVw5RbPz0NK
'' SIG '' N7BdcI9GmZku6Pf0HHHtkKpN7yqhAJHVMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAWnMuorYQ
'' SIG '' rtnGnMFESAlSYOS2xIAWLMpZkk/hWKGqqh0JkumJKL+G
'' SIG '' WidqiJZpHsaSnH76yn/qPv3nFwLrN2P6/PFV8XlI1Ge1
'' SIG '' f8td+DvIWdbBac87uoA0fjb8BY0lq7ENdEFhuu0QyjyD
'' SIG '' t5QrCx6uNTC1nJuvG87J7rHYYdjj06aKkRQrWFuobk1+
'' SIG '' KlYRZ4oTH87w3p+tCi7DMl4cW8wXa4MQIcjei0c5XjML
'' SIG '' H5gV16a3hwXtYYL/px01vqjtTukx7cT1Okt58NaGZVSt
'' SIG '' w6UBaAWIPiHx5Y6+6+MLobuiVnV9GW1cB53YdWXWVxZJ
'' SIG '' 3u1TicnFaeGCDM3TWKar/9qlnaGCDskwgg7FBgorBgEE
'' SIG '' AYI3AwMBMYIOtTCCDrEGCSqGSIb3DQEHAqCCDqIwgg6e
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQ
'' SIG '' AQSgaQRnMGUCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCCZelYQV9yWr7lEN2/dAlHLZHzoaWZ1vqYx
'' SIG '' 6JILk4eCRwIRANqN/UMYwCcfRx0sxi6+GxwYDzIwMjAx
'' SIG '' MDA0MDAyMTAyWqCCC7swggaCMIIFaqADAgECAhAEzT+F
'' SIG '' aK52xhuw/nFgzKdtMA0GCSqGSIb3DQEBCwUAMHIxCzAJ
'' SIG '' BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
'' SIG '' GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNV
'' SIG '' BAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1l
'' SIG '' c3RhbXBpbmcgQ0EwHhcNMTkxMDAxMDAwMDAwWhcNMzAx
'' SIG '' MDE3MDAwMDAwWjBMMQswCQYDVQQGEwJVUzEXMBUGA1UE
'' SIG '' ChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG1RJTUVT
'' SIG '' VEFNUC1TSEEyNTYtMjAxOS0xMC0xNTCCASIwDQYJKoZI
'' SIG '' hvcNAQEBBQADggEPADCCAQoCggEBAOlkNZz6qZhlZBvk
'' SIG '' F9y4KTbMZwlYhU0w4Mn/5Ts8EShQrwcx4l0JGML2iYxp
'' SIG '' CAQj4HctnRXluOihao7/1K7Sehbv+EG1HTl1wc8vp6xF
'' SIG '' fpRtrAMBmTxiPn56/UWXMbT6t9lCPqdVm99aT1gCqDJp
'' SIG '' IhO+i4Itxpira5u0yfJlEQx0DbLwCJZ0xOiySKKhFKX4
'' SIG '' +uGJcEQ7je/7pPTDub0ULOsMKCclgKsQSxYSYAtpIoxO
'' SIG '' zcbVsmVZIeB8LBKNcA6Pisrg09ezOXdQ0EIsLnrOnGd6
'' SIG '' OHdUQP9PlQQg1OvIzocUCP4dgN3Q5yt46r8fcMbuQhZT
'' SIG '' NkWbUxlJYp16ApuVFKMCAwEAAaOCAzgwggM0MA4GA1Ud
'' SIG '' DwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB
'' SIG '' /wQMMAoGCCsGAQUFBwMIMIIBvwYDVR0gBIIBtjCCAbIw
'' SIG '' ggGhBglghkgBhv1sBwEwggGSMCgGCCsGAQUFBwIBFhxo
'' SIG '' dHRwczovL3d3dy5kaWdpY2VydC5jb20vQ1BTMIIBZAYI
'' SIG '' KwYBBQUHAgIwggFWHoIBUgBBAG4AeQAgAHUAcwBlACAA
'' SIG '' bwBmACAAdABoAGkAcwAgAEMAZQByAHQAaQBmAGkAYwBh
'' SIG '' AHQAZQAgAGMAbwBuAHMAdABpAHQAdQB0AGUAcwAgAGEA
'' SIG '' YwBjAGUAcAB0AGEAbgBjAGUAIABvAGYAIAB0AGgAZQAg
'' SIG '' AEQAaQBnAGkAQwBlAHIAdAAgAEMAUAAvAEMAUABTACAA
'' SIG '' YQBuAGQAIAB0AGgAZQAgAFIAZQBsAHkAaQBuAGcAIABQ
'' SIG '' AGEAcgB0AHkAIABBAGcAcgBlAGUAbQBlAG4AdAAgAHcA
'' SIG '' aABpAGMAaAAgAGwAaQBtAGkAdAAgAGwAaQBhAGIAaQBs
'' SIG '' AGkAdAB5ACAAYQBuAGQAIABhAHIAZQAgAGkAbgBjAG8A
'' SIG '' cgBwAG8AcgBhAHQAZQBkACAAaABlAHIAZQBpAG4AIABi
'' SIG '' AHkAIAByAGUAZgBlAHIAZQBuAGMAZQAuMAsGCWCGSAGG
'' SIG '' /WwDFTAfBgNVHSMEGDAWgBT0tuEgHf4prtLkYaWyoiWy
'' SIG '' yBc1bjAdBgNVHQ4EFgQUVlMPwcYHp03X2G5XcoBQTOTs
'' SIG '' nsEwcQYDVR0fBGowaDAyoDCgLoYsaHR0cDovL2NybDMu
'' SIG '' ZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC10cy5jcmww
'' SIG '' MqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9z
'' SIG '' aGEyLWFzc3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5
'' SIG '' MHcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2lj
'' SIG '' ZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2Vy
'' SIG '' dHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3Vy
'' SIG '' ZWRJRFRpbWVzdGFtcGluZ0NBLmNydDANBgkqhkiG9w0B
'' SIG '' AQsFAAOCAQEALoOhRAVKBOO5MlL62YHwGrv4CY0juT3Y
'' SIG '' kqHmRhxKL256PGNuNxejGr9YI7JDnJSDTjkJsCzox+Hi
'' SIG '' zO3LeWvO3iMBR+2VVIHggHsSsa8Chqk6c2r++J/BjdEh
'' SIG '' jOQpgsOKC2AAAp0fR8SftApoU39aEKb4Iub4U5IxX9iC
'' SIG '' gy1tE0Kug8EQTqQk9Eec3g8icndcf0/pOZgrV5JE1+9u
'' SIG '' k9lDxwQzY1E3Vp5HBBHDo1hUIdjijlbXST9X/AqfI157
'' SIG '' 9JSN3Z0au996KqbSRaZVDI/2TIryls+JRtwxspGQo18z
'' SIG '' MGBV9fxrMKyh7eRHTjOeZ2ootU3C7VuXgvjLqQhsUwm0
'' SIG '' 9zCCBTEwggQZoAMCAQICEAqhJdbWMht+QeQF2jaXwhUw
'' SIG '' DQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQg
'' SIG '' QXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
'' SIG '' MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMx
'' SIG '' FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
'' SIG '' d3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNl
'' SIG '' cnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBD
'' SIG '' QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
'' SIG '' AL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0UzURB90Pl9
'' SIG '' TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcu
'' SIG '' HjvuzKb2Mln+X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/
'' SIG '' Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPuXciaC1TjqAlx
'' SIG '' a+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287Dxg
'' SIG '' aqwvB8z98OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn
'' SIG '' 5HU+upgPhH+fMRTWrdXyZMt7HgXQhBlyF/EXBu89zdZN
'' SIG '' 7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOC
'' SIG '' Ac4wggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWy
'' SIG '' yBc1bjAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd
'' SIG '' 823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5Bggr
'' SIG '' BgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9v
'' SIG '' Y3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3aHR0
'' SIG '' cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
'' SIG '' QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6
'' SIG '' oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0Rp
'' SIG '' Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0
'' SIG '' aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
'' SIG '' QXNzdXJlZElEUm9vdENBLmNybDBQBgNVHSAESTBHMDgG
'' SIG '' CmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6
'' SIG '' Ly93d3cuZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggEBAHGVEulRh1Zpze/d
'' SIG '' 2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysf
'' SIG '' DCFaKrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLo
'' SIG '' XoIlHsS6HHssIeLWWywUNUMEaLLbdQLgcseY1jxk5R9I
'' SIG '' EBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
'' SIG '' 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4Ui
'' SIG '' jGHKeZR+WfyMD+NvtQEmtmyl7odRIeRYYJu6DC0rbaLE
'' SIG '' frvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR79VYz
'' SIG '' Ii8iNrJLokqV2PWmjlIxggJNMIICSQIBATCBhjByMQsw
'' SIG '' CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5j
'' SIG '' MRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
'' SIG '' VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgVGlt
'' SIG '' ZXN0YW1waW5nIENBAhAEzT+FaK52xhuw/nFgzKdtMA0G
'' SIG '' CWCGSAFlAwQCAQUAoIGYMBoGCSqGSIb3DQEJAzENBgsq
'' SIG '' hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAxMDA0
'' SIG '' MDAyMTAyWjArBgsqhkiG9w0BCRACDDEcMBowGDAWBBQD
'' SIG '' Jb1QXtqWMC3CL0+gHkwovig0xTAvBgkqhkiG9w0BCQQx
'' SIG '' IgQgySVoQYg6zCzTYaBPlZlFNaafAOKhRyw0UX0PLJoR
'' SIG '' THcwDQYJKoZIhvcNAQEBBQAEggEASyLU4cLwooq3mpgN
'' SIG '' mjuQuiqfhDPRJJx8mTjlkg14vpu2BRLc9TxI919Rt6LZ
'' SIG '' M+MpMW3mAZfEkU98MpBedZl62wYLddtEaKjZT52FmJtb
'' SIG '' TP+RbEPMafrR0LzXOEFvZyC39bOWXk+jPVme9cFLlgP+
'' SIG '' zQXEXkSnomawwocZAkWQ5opSQHxhXmFnOQRtPdWFSFee
'' SIG '' M0tkQHKH12CdXGiWdsDj2w3hZPQULcHY6gRe/z73cov5
'' SIG '' 7c5kUI/wiDC6QMKcosMX1tCmSWP0gsQR+96/frSVLrsX
'' SIG '' ALstLQNfYej+3TzFztxBEoWL7Pk4cYOphBqSdnqe7oZO
'' SIG '' LToP1WeYylZpf8TmMQ==
'' SIG '' End signature block
